@props([
    'items' => []
])

<nav class="flex flex-1 flex-col pt-2" aria-label="Sidebar">
    <ul role="list" class="-mx-2 space-y-1">
        @foreach($items as $item)
            @if($item->getType() === 'divider')
                <li class="pt-4 pb-2">
                    <div class="border-t" aria-hidden="true"></div>
                    <p class="mt-4 ml-3 uppercase text-xs leading-loose text-gray-600">{{ $item->getLabel() }}</p>
                </li>
            @else
                <li x-data="{ open: {{ $item->isActive() ? 'true' : 'false' }} }">
                    @if($item->getChildren()->isNotEmpty())
                        <button
                            @click="open = !open"
                            type="button"
                            class="{{ $item->isActive() ? 'bg-gray-100 text-sky-600' : 'text-gray-700 hover:text-sky-600 hover:bg-gray-100' }} group w-full flex items-center gap-x-3 rounded-md p-2 pl-3 text-sm font-semibold leading-6">
                            <span class="flex-1 text-left">{{ $item->getLabel() }}</span>
                            <svg class="ml-auto h-5 w-5 shrink-0 transition-transform" :class="open ? 'rotate-90' : ''" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                            </svg>
                        </button>
                        <ul x-show="open" x-collapse class="mt-1 px-2">
                            @foreach($item->getChildren() as $child)
                                @if($child->getType() !== 'divider')
                                    <li>
                                        <a
                                            href="{{ $child->getUrl() }}"
                                            class="{{ $child->isActive() ? 'bg-gray-100 text-sky-600' : 'text-gray-700 hover:text-sky-600 hover:bg-gray-100' }} group flex gap-x-3 rounded-md p-2 pl-3 text-sm leading-6">
                                            {{ $child->getLabel() }}
                                        </a>
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    @else
                        <a
                            href="{{ $item->getUrl() }}"
                            class="{{ $item->isActive() ? 'bg-gray-100 text-sky-600' : 'text-gray-700 hover:text-sky-600 hover:bg-gray-100' }} group flex gap-x-3 rounded-md p-2 pl-3 text-sm font-semibold leading-6">
                            {{ $item->getLabel() }}
                        </a>
                    @endif
                </li>
            @endif
        @endforeach
    </ul>
</nav>
