<?php

namespace Daylight\Core\Models\Enums;

enum OrderStatus: string
{
    case PROCESSING = 'processing';

    case COMPLETED = 'completed';

    case CANCELLED = 'cancelled';

    case REFUNDED = 'refunded';

    case FAILED = 'failed';

    case PENDING = 'pending';

    case ON_HOLD = 'on_hold';

    case AWAITING_PAYMENT = 'awaiting_payment';

    public function label(): string
    {
        return match ($this) {
            self::PROCESSING => __('daylight::general.orderStatuses.processing'),
            self::COMPLETED => __('daylight::general.orderStatuses.completed'),
            self::CANCELLED => __('daylight::general.orderStatuses.cancelled'),
            self::REFUNDED => __('daylight::general.orderStatuses.refunded'),
            self::FAILED => __('daylight::general.orderStatuses.failed'),
            self::PENDING => __('daylight::general.orderStatuses.pending'),
            self::ON_HOLD => __('daylight::general.orderStatuses.on_hold'),
            self::AWAITING_PAYMENT => __('daylight::general.orderStatuses.awaiting_payment'),
        };
    }

    public function adminColor(): string
    {
        return match ($this) {
            self::COMPLETED => 'bg-blue-50 text-blue-700',
            self::PROCESSING => 'bg-green-50 text-green-700',
            self::PENDING, self::ON_HOLD => 'bg-yellow-50 text-yellow-800',
            self::AWAITING_PAYMENT => 'bg-gray-50 text-gray-600',
            default => 'bg-red-50 text-red-700',
        };
    }
}
