<?php

namespace Daylight\Core\Models\Translations;

use Daylight\Core\Modules\PageBuilder\Concerns\InteractsWithComponents;
use Daylight\Core\Modules\PageBuilder\Contracts\HasComponents;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PageTranslation extends Model implements HasComponents
{
    use InteractsWithComponents;

    protected $guarded = [];

    public function page(): BelongsTo
    {
        return $this->belongsTo(daylightModel('page'));
    }
}
