<?php

namespace Daylight\Core\Database\Seeders;

use Daylight\Core\Models\Country;
use Daylight\Core\Models\TaxClass;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Cache;

class CountrySeeder extends Seeder
{
    protected array $countries = [
        'AT' => [ // Austria
            'name' => 'VAT',
            'rates' => [
                1 => 20,
                2 => 10,
                3 => 13,
            ],
        ],
        'BE' => [ // Belgium
            'name' => 'BTW / VAT',
            'rates' => [
                1 => 21,
                2 => 12,
                3 => 0,
            ],
        ],
        'BG' => [ // Bulgaria
            'name' => 'VAT',
            'rates' => [
                1 => 20,
                2 => 9,
                3 => 0,
            ],
        ],
        'CH' => [ // Switzerland
            'name' => 'BTW / VAT',
            'rates' => [
                1 => 7.7,
                2 => 3.7,
                3 => 0,
            ],
        ],
        'CY' => [ // Cyprus
            'name' => 'VAT',
            'rates' => [
                1 => 19,
                2 => 9,
                3 => 0,
            ],
        ],
        'CZ' => [ // Czech Republic
            'name' => 'VAT',
            'rates' => [
                1 => 21,
                2 => 15,
                3 => 0,
            ],
        ],
        'DE' => [ // Germany
            'name' => 'VAT',
            'rates' => [
                1 => 19,
                2 => 7,
                3 => 0,
            ],
        ],
        'DK' => [// Denmark
            'name' => 'VAT',
            'rates' => [
                1 => 25,
                2 => 0,
                3 => 0,
            ],
        ],
        'EE' => [ // Estonia
            'name' => 'VAT',
            'rates' => [
                1 => 20,
                2 => 9,
                3 => 0,
            ],
        ],
        'ES' => [ // Spain
            'name' => 'VAT',
            'rates' => [
                1 => 21,
                2 => 10,
                3 => 0,
            ],
        ],
        'FI' => [ // Finland
            'name' => 'VAT',
            'rates' => [
                1 => 24,
                2 => 14,
                3 => 0,
            ],
        ],
        'FR' => [ // France
            'name' => 'VAT',
            'rates' => [
                1 => 20,
                2 => 10,
                3 => 0,
            ],
        ],
        'GB' => [// United Kingdom
            'name' => 'BTW / VAT',
            'rates' => [
                1 => 20,
                2 => 5,
                3 => 0,
            ],
        ],
        'GR' => [ // Greece
            'name' => 'VAT',
            'rates' => [
                1 => 24,
                2 => 13,
                3 => 0,
            ],
        ],
        'HR' => [ // Croatia
            'name' => 'VAT',
            'rates' => [
                1 => 25,
                2 => 13,
                3 => 0,
            ],
        ],
        'HU' => [ // Hungary
            'name' => 'VAT',
            'rates' => [
                1 => 27,
                2 => 18,
                3 => 0,
            ],
        ],
        'IE' => [ // Ireland
            'name' => 'VAT',
            'rates' => [
                1 => 23,
                2 => 13.5,
                3 => 0,
            ],
        ],
        'IM' => [ //
            'name' => 'VAT',
            'rates' => [
                1 => 20,
                2 => 5,
                3 => 0,
            ],
        ],
        'IT' => [ // Italy
            'name' => 'VAT',
            'rates' => [
                1 => 22,
                2 => 10,
                3 => 0,
            ],
        ],
        'LT' => [ // Lithuania
            'name' => 'VAT',
            'rates' => [
                1 => 21,
                2 => 9,
                3 => 0,
            ],
        ],
        'LU' => [ // Luxembourg
            'name' => 'VAT',
            'rates' => [
                1 => 17,
                2 => 14,
                3 => 0,
            ],
        ],
        'LV' => [ // Latvia
            'name' => 'VAT',
            'rates' => [
                1 => 21,
                2 => 12,
                3 => 0,
            ],
        ],
        'MC' => [ // Monaco
            'name' => 'VAT',
            'rates' => [
                1 => 20,
                2 => 10,
                3 => 0,
            ],
        ],
        'MD' => [ // Moldova
            'name' => 'BTW / VAT',
            'rates' => [
                1 => 20,
                2 => 8,
                3 => 0,
            ],
        ],
        'MT' => [ // Malta
            'name' => 'VAT',
            'rates' => [
                1 => 18,
                2 => 7,
                3 => 0,
            ],
        ],
        'NL' => [ // Netherlands
            'name' => 'BTW',
            'rates' => [
                1 => 21,
                2 => 9,
                3 => 0,
            ],
        ],
        'NO' => [ // Norway
            'name' => 'BTW / VAT',
            'rates' => [
                1 => 25,
                2 => 15,
                3 => 0,
            ],
        ],
        'PL' => [ // Poland
            'name' => 'VAT',
            'rates' => [
                1 => 23,
                2 => 8,
                3 => 0,
            ],
        ],
        'PT' => [ // Portugal
            'name' => 'VAT',
            'rates' => [
                1 => 23,
                2 => 13,
                3 => 0,
            ],
        ],
        'RO' => [ // Romania
            'name' => 'VAT',
            'rates' => [
                1 => 19,
                2 => 9,
                3 => 0,
            ],
        ],
        'SE' => [ // Sweden
            'name' => 'VAT',
            'rates' => [
                1 => 25,
                2 => 12,
                3 => 0,
            ],
        ],
        'SI' => [ // Slovenia
            'name' => 'VAT',
            'rates' => [
                1 => 22,
                2 => 9.5,
                3 => 0,
            ],
        ],
        'SK' => [ // Slovakia
            'name' => 'VAT',
            'rates' => [
                1 => 20,
                2 => 10,
                3 => 0,
            ],
        ],
        'TR' => [ // Turkey
            'name' => 'BTW / VAT',
            'rates' => [
                1 => 18,
                2 => 8,
                3 => 0,
            ],
        ],
    ];

    public function run(): void
    {
        TaxClass::create(['name' => 'Standard']);
        TaxClass::create(['name' => 'Reduced']);
        TaxClass::create(['name' => 'Zero']);

        foreach ($this->countries as $code => $data) {
            tap(Country::create([
                'code' => $code,
                'default' => $code === 'NL',
            ]), function (Country $country) use ($data) {
                foreach ($data['rates'] as $class => $rate) {
                    $country->taxRates()->create([
                        'tax_class_id' => $class,
                        'name' => $data['name'],
                        'rate' => $rate,
                    ]);
                }
            });
        }

        Cache::forget('countries');
    }
}
