@props([
    'withPagination' => true,
])
<div>
    {{ $heading ?? '' }}

    @if(isset($this->multilingualism) && $this->multilingualism || isset($this->searchable) && $this->searchable)
        <div class="flex space-x-4 w-full mb-8">
            @if(isset($this->multilingualism) && $this->multilingualism)
                <x-daylight::tables.multilingualism/>
            @endif

            @if(isset($this->searchable) && $this->searchable)
                <x-daylight::tables.search/>
            @endif
        </div>
    @endif

    <table class="min-w-full table-fixed divide-y divide-gray-300 text-gray-800">
        <thead>
        <tr>
            <th class="p-3 text-left text-sm font-semibold text-gray-900" width="50">
                <div class="flex items-center">
                    <x-daylight::tables.check-all/>
                </div>
            </th>

            {{ $columns ?? '' }}

            <th>
                &nbsp;
            </th>
        </tr>
        </thead>

        <tbody class="divide-y divide-gray-200 bg-white text-gray-700">
        {{ $slot }}
        </tbody>
    </table>

    <div class="flex space-x-4 mt-8">
        @if(isset($this->bulkActions) && $this->bulkActions)
            <x-daylight::tables.bulk-actions/>
        @endif

        @if($withPagination)
            <div class="flex-grow">
                {{ $this->rows->links() }}
            </div>
        @endif
    </div>
</div>
