@extends('daylight::layouts.app')

@section('title', __('Create new page'))

@section('content')
    <x-daylight::page-header :title="__('Create new page')"/>
    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.content.pages.store') }}" x-data="{ name: '{{ old('name') }}'}">
        @csrf

        <x-daylight::input.group
                :label="__('Locale')"
                :error="$errors->first('locale')"
                for="locale"
        >
            <x-daylight::input.select name="locale" id="locale">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <option value="{{ $locale }}" {{ old('locale') === $locale ? 'selected' : '' }}>
                        {{ strtoupper($locale) }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
                :label="__('Name')"
                :error="$errors->first('name')"
                for="name"
        >
            <x-daylight::input.text name="name" id="name" value="{{ old('name') }}" x-model="name"/>
        </x-daylight::input.group>

        <x-daylight::input.group
                :label="__('Slug')"
                :error="$errors->first('slug')"
                :helpText="__('Unique identifier of this page. This must be unique since the page URL will be built on this.')"
                for="slug"
        >
            <x-daylight::input.text name="slug" id="slug" value="{{ old('slug') }}" x-slug="name" readonly/>
        </x-daylight::input.group>

        @if($templates->isNotEmpty())
            <x-daylight::input.group
                :label="__('Template')"
                :error="$errors->first('template')"
                for="template"
            >
                <x-daylight::input.select name="template" id="template">
                    @foreach($templates as $template)
                        <option value="{{ $template->getKey() }}" {{ old('template') === $template->getKey() ? 'selected' : '' }}>
                            {{ $template->getLabel() }}
                        </option>
                    @endforeach
                </x-daylight::input.select>
            </x-daylight::input.group>
        @endif

        <x-daylight::seo/>

        <div>
            <h2 class="mt-12">{{ __('Components') }}</h2>
            <x-daylight::input.group
                    :label="__('Components')"
                    :error="$errors->first('components')"
                    for="components"
            >
                <div wire:ignore>
                    <div data-vue-app>
                        <page-builder
                                :components='@json(old('components', $components) ? json_decode(old('components', $components)) : [])'
                                :available-components='@json($availableComponents)'
                        />
                    </div>
                </div>
            </x-daylight::input.group>
        </div>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.pages.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
