<table style="border-collapse: collapse;" width="100%" cellpadding="0" cellspacing="0">
    @foreach($order->items as $item)
        <tr height="5"></tr>
        <tr style="border-bottom: 1px solid rgba(0, 0, 0, .1);padding-bottom: 10px;">
            <td style="width: 84px;">
                @if($item->variant->getFirstMedia('gallery'))
                    <img src="{{ $item->variant->getFirstMedia('gallery')->getUrl('thumbnail') }}" alt="{{ $item->name }}" style="margin: 10px 0;object-fit: contain; width: 64px; height: 64px;border: 1px solid #DCDFDE;">
                @endif
            </td>
            <td width="50%">
                <h3 style="margin-bottom: 5px;margin-right: 10px;font-size:14px; font-weight: 500;color: #333;">{{ $item->name }}</h3>
                <p style="font-size:12px; margin-bottom: 0;">{{ $item->variant->variantName }} </p>
                <p style="font-size:12px;margin-bottom: 0;">{{ $item->sku }} </p>
            </td>
            <td>
                <p style="font-size:12px;margin-bottom: 0;">{{ $item->quantity }} &times;</p>
            </td>
            <td align="right">
                <p style="font-size:12px;margin-bottom: 0;text-align: right;font-weight: 500;color: #333;">{{ formatPrice($item->quantity * $item->price) }}</p>
            </td>
        </tr>
    @endforeach
</table>

<table cellspacing="0" cellpadding="0" width="100%" style="margin-top: 15px;border-collapse: collapse;">
    <tr>
        <td colspan="2" valign="top" style="line-height: 1;">
            <p style="font-size:14px;font-weight:500;color: #333;margin-bottom: 5px;">{{ __('Payment method') }}</p>
            <p style="font-size:14px;margin-bottom: 0;">{{ $order->payment_method->label() }}</p>
        </td>
        <td align="right" valign="bottom">
            <table cellspacing="0" cellspacing="0">
                <tr>
                    <td style="font-size:14px;margin-bottom: 0;">{{ __('Subtotal') }}</td>
                    <td align="right">
                        <p style="font-size:14px;margin-bottom: 0;text-align: right;">{{ formatPrice($order->subtotal) }}</p>
                    </td>
                </tr>
                @if($order->shipping > 0)
                    <tr>
                        <td style="font-size:14px;margin-bottom: 0;">{{ __('Shipping') }}</td>
                        <td align="right">
                            <p style="font-size:14px;margin-bottom: 0;text-align: right;">{{ formatPrice($order->shipping) }}</p>
                        </td>
                    </tr>
                @endif
                @foreach($order->tax_breakdown as $tax)
                    <tr>
                        <td style="font-size:14px;margin-bottom: 0;">{{ $tax['name'] }} ({{ round($tax['rate'], 1) }}%)</td>
                        <td align="right">
                            <p style="font-size:14px;margin-bottom: 0;text-align: right;">{{ formatPrice($tax['amount'] / 100) }}</p>
                        </td>
                    </tr>
                @endforeach
                <tr>
                    <td colspan="2" style="line-height:5px;">&nbsp;</td>
                </tr>
                <tr>
                    <td style="font-size:14px;margin-bottom: 0;font-weight:500;color: #333;">{{ __('Total') }}</td>
                    <td align="right">
                        <p style="padding-left: 30px;color: #333;font-size:14px;margin-bottom: 0;text-align: right;font-weight:500;">{{ formatPrice($order->total) }}</p>
                    </td>
                </tr>
            </table>
        </td>
    </tr>

    <tr>
        <td>&nbsp;</td>
    </tr>

    <tr>
        <td width="100%" colspan="3">
            <table cellspacing="0" cellpadding="0" width="100%" style="margin-bottom: 30px;">
                <tr>
                    <td width="50%" valign="top">
                        <strong style="font-size:14px;font-weight:500;color: #333;margin-bottom: 5px;">{{ __('Billing information') }}</strong>
                        @if($order->billingAddress->name)
                            <p style="font-size:14px;margin-bottom: 0;">{{ $order->billingAddress->name  }}</p>
                        @endif
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->billingAddress->address_line_1 }}</p>
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->billingAddress->address_line_2 }}</p>
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->billingAddress->postal_code }} {{ $order->billingAddress->city }}</p>
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->billingAddress->country->name }}</p>
                        @if($order->reference)
                            <br>
                            <p style="font-size:14px;margin-bottom: 0;">{{ __('Reference') }}: {{ $order->reference }}</p>
                        @endif
                    </td>
                    <td width="50%" valign="top">
                        <strong style="font-size:14px;font-weight:500;color: #333;margin-bottom: 5px;">{{ __('Shipping information') }}</strong>
                        @if($order->shippingAddress->name)
                            <p style="font-size:14px;margin-bottom: 0;">{{ $order->shippingAddress->name  }}</p>
                        @endif
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->shippingAddress->address_line_1 }}</p>
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->shippingAddress->address_line_2 }}</p>
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->shippingAddress->postal_code }} {{ $order->shippingAddress->city }}</p>
                        <p style="font-size:14px;margin-bottom: 0;">{{ $order->shippingAddress->country->name }}</p>
                    </td>
                </tr>
            </table>
        </td>
    </tr>

    <tr>
        <td width="100%" colspan="3">
            <p style="font-size:14px;margin-bottom: 0;">{!! __('If you have any questions regarding your order, please contact us at <a href="mailto::email" style="color: #333;">:email</a>.', [ 'email' => app(\Daylight\Core\Settings\General::class)->email]) !!}</p>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
</table>
