<?php

namespace Daylight\Core\Http\Controllers\Store;

use Daylight\Core\Http\Controllers\Controller;
use Daylight\Core\Models\Customer;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;
use Illuminate\View\View;

class CustomerController extends Controller implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:create:customers', only: ['create', 'store']),
            new Middleware('can:read:customers', only: ['index', 'show']),
            new Middleware('can:update:customers', only: ['edit', 'update']),
            new Middleware('can:delete:customers', only: ['destroy']),
        ];
    }

    public function index(): View
    {
        return view('daylight::store.customers.index');
    }

    public function show(Customer $customer)
    {
        $customer = (daylightModel('customer'))::query()
            ->withCount('orders', 'users', 'orders')
            ->withSum('orders', 'total')
            ->with([
                'defaultBillingAddress',
                'addresses.country',
            ])
            ->findOrFail($customer->id);

        return view('daylight::store.customers.show', [
            'customer' => $customer,
        ]);
    }

    public function edit(Customer $customer)
    {
        dd($customer);
    }
}
