<?php

namespace Daylight\Core\Http\Requests\Settings\ShippingClasses;

use Illuminate\Foundation\Http\FormRequest;

class UpdateShippingClassRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:advanced-settings');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'default' => ['required', 'integer', 'between:0,1'],
            'cumulative' => ['required', 'integer', 'between:0,1'],
        ];
    }
}
