<?php

namespace Daylight\Core\Models\Enums;

enum OrderStatus: string
{
    case PROCESSING = 'processing';

    case COMPLETED = 'completed';

    case CANCELLED = 'cancelled';

    case REFUNDED = 'refunded';

    case FAILED = 'failed';

    case PENDING = 'pending';

    case ON_HOLD = 'on_hold';

    case AWAITING_PAYMENT = 'awaiting_payment';

    public function label(): string
    {
        return match ($this) {
            self::PROCESSING => __('Processing'),
            self::COMPLETED => __('Completed'),
            self::CANCELLED => __('Cancelled'),
            self::REFUNDED => __('Refunded'),
            self::FAILED => __('Failed'),
            self::PENDING => __('Pending'),
            self::ON_HOLD => __('On Hold'),
            self::AWAITING_PAYMENT => __('Awaiting Payment'),
        };
    }

    public function adminColor(): string
    {
        return match ($this) {
            self::COMPLETED => 'bg-blue-50 text-blue-700',
            self::PROCESSING => 'bg-green-50 text-green-700',
            self::PENDING, self::ON_HOLD => 'bg-yellow-50 text-yellow-800',
            self::AWAITING_PAYMENT => 'bg-gray-50 text-gray-600',
            default => 'bg-red-50 text-red-700',
        };
    }
}
