<?php

namespace Daylight\Core\Modules\Admin\Entities;

use Daylight\Core\Modules\Admin\Entities\Contracts\NavigationItem;

class Divider implements NavigationItem
{
    public string $label;

    public int $order = 0;

    public ?string $parent = null;

    public function __construct()
    {
        //
    }

    public function setParent(?string $parent): self
    {
        $this->parent = $parent;

        return $this;
    }

    public function setLabel(string $label): self
    {
        $this->label = $label;

        return $this;
    }

    public function setOrder(int $order): self
    {
        $this->order = $order;

        return $this;
    }

    public static function create(): self
    {
        return new self;
    }

    public function getType(): string
    {
        return 'divider';
    }

    public function getOrder(): int
    {
        return $this->order;
    }
}
