<?php

namespace Daylight\Core\Http\Requests\Concerns;

use Illuminate\Validation\Rule;

trait HandlesSeoRequest
{
    public function getSeoRules(): array
    {
        return [
            'meta_title' => ['nullable', 'string', 'max:255'],
            'meta_description' => ['nullable', 'string', 'max:255'],
            'robots' => ['nullable', 'string', 'max:255', Rule::in(['index, follow', 'noindex, nofollow', 'nofollow', 'noindex'])],
        ];
    }
}
