<?php

namespace Daylight\Core\Messages;

use Daylight\Core\Models\Order;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\HtmlString;

class OrderOverviewMailMessage extends MailMessage
{
    public function renderOrderOverview(Order $order): self
    {
        // view('daylight::content.pages.index')
        $data = preg_split("/\r\n|\n|\r/", view('daylight::mail.order-overview', [
            'order' => $order,
        ])->render());

        $data = array_map('trim', $data);

        collect($data)->each(function ($line) {
            $this->line(new HtmlString($line));
        });

        return $this;
    }
}
