<?php

namespace Daylight\Core\Models\Enums;

use Illuminate\Support\Collection;

enum DisplayType: string
{
    case PRODUCTS = 'products';

    case SUBCATEGORIES = 'subcategories';

    public function label(): string
    {
        return match ($this) {
            self::PRODUCTS => __('daylight::store.display_types.products'),
            self::SUBCATEGORIES => __('daylight::store.display_types.subcategories'),
        };
    }

    public static function formattedValues(): Collection
    {
        return collect(self::cases())
            ->mapWithKeys(function (DisplayType $status) {
                return [$status->value => $status->label()];
            });
    }
}
