<?php

namespace Daylight\Core\Modules\MenuBuilder\Http\Requests;

use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateMenuRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:menus');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'locale' => ['required', 'string', Rule::in(Multilingualism::getAvailableLocales())],
            'items' => ['required', 'json'],
        ];
    }
}
