<?php

namespace Daylight\Core\Modules\MenuBuilder\Models;

use Daylight\Core\Modules\MenuBuilder\Events\MenuUpdated;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Menu extends Model implements HasTranslations
{
    protected $guarded = [];

    protected $dispatchesEvents = [
        'updated' => MenuUpdated::class,
    ];

    public function translations(): HasMany
    {
        return $this->hasMany(MenuTranslation::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this->hasOne(MenuTranslation::class)
            ->where('locale', config('app.fallback_locale'));
    }
}
