@props([
    'files',
    'selectable' => false,
    'selectedItems' => [],
])

@if($files->total() > 0)
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 xl:grid-cols-8 2xl:grid-cols-10 gap-6 mt-8">
        @foreach($files as $file)
            @php
                $isSelected = collect($selectedItems)->contains(fn($i) => (int)($i['id'] ?? 0) === (int)$file->id);
            @endphp
            <button type="button" class="group relative" wire:click="selectFile({{ $file->id }})">
                <div class="relative rounded-lg overflow-hidden ring-2 {{ $isSelected ? 'ring-sky-600' : 'ring-transparent' }}">
                    <div class="absolute inset-0 bg-black bg-opacity-25 opacity-0 group-hover:opacity-100 transition"></div>
                    <img class="aspect-square rounded-lg object-cover" src="{{ method_exists($file, 'getUrl') ? $file->getUrl('thumbnail') : (is_array($file) ? ($file['thumbnail_url'] ?? '') : '') }}" alt="{{ $file->name }}">
                </div>

                <div class="mt-2 text-left">
                    <h3 class="text-gray-600 mb-0 text-sm truncate">{{ $file->name }}</h3>
                    <p class="text-gray-400 mt-0 text-xs">{{ number_format((int) $file->size / 1024, 0) }} kb</p>
                </div>
            </button>
        @endforeach
    </div>

    <div class="mt-6">
        {{ $files->onEachSide(1)->links() }}
    </div>
@endif


