@extends('daylight::layouts.app')

@section('title', __('daylight::content.create_new_page'))

@section('content')
    <x-daylight::page-header :title="__('daylight::content.create_new_page')"/>
    <x-daylight::session-messages/>

    <form
        method="post"
        action="{{ route('daylight.content.pages.store') }}"
        x-data="{ name: '{{ old('name') }}' }"
        x-on:submit="
        const jsonFields = document.querySelectorAll('textarea[name^=components_json]');
        jsonFields.forEach((field) => {
            const match = field.name.match(/\[(\d+)\]/);
            if (match) {
                const index = parseInt(match[1]);
                const componentEl = field.closest('[wire\\:id]');
                if (componentEl) {
                    const livewireId = componentEl.getAttribute('wire:id');
                    if (livewireId && window.Livewire) {
                        const component = window.Livewire.find(livewireId);
                        if (component && component.get && component.get('components')) {
                            const components = component.get('components');
                            if (components && components[index]) {
                                field.value = JSON.stringify(components[index]);
                            }
                        }
                    }
                }
            }
        });
    "
    >
        @csrf

        <x-daylight::input.group
                :label="__('daylight::content.fields.locale')"
                :error="$errors->first('locale')"
                for="locale"
        >
            <x-daylight::input.select name="locale" id="locale">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <option value="{{ $locale }}" {{ old('locale') === $locale ? 'selected' : '' }}>
                        {{ strtoupper($locale) }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
                :label="__('daylight::general.name')"
                :error="$errors->first('name')"
                for="name"
        >
            <x-daylight::input.text name="name" id="name" value="{{ old('name') }}" x-model="name"/>
        </x-daylight::input.group>

        <x-daylight::input.group
                :label="__('daylight::general.slug')"
                :error="$errors->first('slug')"
                :helpText="__('daylight::content.fields.help_slug_unique')"
                for="slug"
        >
            <x-daylight::input.text name="slug" id="slug" value="{{ old('slug') }}" x-slug="name" readonly/>
        </x-daylight::input.group>

        @if($templates->isNotEmpty())
            <x-daylight::input.group
                :label="__('daylight::content.fields.template')"
                :error="$errors->first('template')"
                for="template"
            >
                <x-daylight::input.select name="template" id="template">
                    @foreach($templates as $template)
                        <option value="{{ $template->getKey() }}" {{ old('template') === $template->getKey() ? 'selected' : '' }}>
                            {{ $template->getLabel() }}
                        </option>
                    @endforeach
                </x-daylight::input.select>
            </x-daylight::input.group>
        @endif

        <x-daylight::seo/>

        <div>
            <h2 class="mt-12">{{ __('daylight::general.components') }}</h2>
            <x-daylight::input.group
                    :label="__('daylight::general.components')"
                    :error="$errors->first('components')"
                    for="components"
            >
                @php
                    $componentsData = old('components', []);
                    if (is_string($componentsData)) {
                        $componentsData = json_decode($componentsData, true);
                    }
                    $componentsData = $componentsData ?: [];
                @endphp
                <livewire:daylight::page-builder
                    :components="$componentsData"
                    :availableComponents="$availableComponents->toArray()"
                    name="components"
                />
            </x-daylight::input.group>
        </div>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.pages.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
