<div>
    <div class="w-full mt-4 bg-white rounded-lg shadow-md overflow-hidden border-1 border-gray-500">
        <div class="flex item-center justify-between bg-gray-600 p-4 text-white">
            <div class="flex items-center">
                {{ __('daylight::store.product_options') }}
            </div>
        </div>
        <div class="p-4">
            @if ($groupedOptionsToConfig)
                @foreach($groupedOptionsToConfig as $index => $option)
                    <div class="w-full p-4 flex item-center justify-content-start gap-6">
                        <div>
                            <a href="#"
                               class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" class="w-5 h-5 text-red-700">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
                                </svg>
                            </a>
                        </div>
                        <div>
                            {!! $option['name'] !!}
                        </div>
                        <div class="sm:flex sm:items-center">
                            <input type="text"
                               name="variants[{{ $option['ids'] }}]"
                               placeholder="{{ __('daylight::general.sku') }}"
                               wire:model="sku.{{ $index }}"
                               id="searchSku_{{ $index }}"
                               class="flex inline rounded-md bg-white px-3 py-1.5 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                            <button
                                wire:click.prevent="searchSku({{$index}})"
                                class="ml-2 py-2.5 px-4 border rounded-md text-sm leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out bg-sky-600 text-white hover:bg-sky-700 border-sky-600 text-sm0">
                                {{ __('daylight::general.search') }}
                            </button>
                            @isset($this->skuSearch[$index])
                                <ul class="absolute bg-white border rounded w-full mt-1">
                                    @foreach($this->skuSearch[$index] as $result)
                                        <li
                                            class="p-2 hover:bg-gray-200 cursor-pointer"
                                            wire:click="applySku( {{ $result['id'] }}, {{ $index }})">
                                            {{ $result['sku'] }}
                                        </li>
                                    @endforeach
                                </ul>
                            @endisset
                        </div>
                    </div>
                @endforeach
            @else
                <div>
                    <div><em>{{ __('daylight::store.no_product_options_set') }}</em></div>
                </div>
            @endif
        </div>
        <div class="flex item-center justify-content-start bg-gray-100 p-4 gap-6">
            <div>
                <label for="selectOption">{{ __('daylight::store.option') }}</label>
                <div class="mt-2 grid grid-cols-1">
                    <select wire:model="selectedOption" wire:change="setSelectedOption" id="selectOption" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        @foreach ($options as $option)
                            <option value="{{ $option['id'] }}">{{ $option['name'] }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            @if ($showNewOptionInput)
                <div>
                    <label for="newOption">{{ __('daylight::store.new_option') }}</label>
                    <div class="mt-2 grid grid-cols-1">
                        <input type="text" placeholder="{{ __('daylight::store.new_value') }}" wire:model="newOption" id="newOption" class="block w-full rounded-md bg-white px-3 py-1.5 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <button wire:click.prevent="addNewOption" class="mt-2 py-2.5 px-4 border rounded-md text-sm leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out bg-white text-sky-600 hover:opacity-75 border-sky-600">
                            {{ __('daylight::general.add') }}
                        </button>
                    </div>
                </div>
            @endif

            <div>
                @if($this->optionValues)
                    <label for="selectOption">{{ __('daylight::store.option_value') }}</label>
                    <div class="mt-2 grid grid-cols-1 mt-4">
                        @foreach($this->optionValues as $optionValue)
                            <div class="relative flex gap-3">
                                <div class="min-w-0 flex-1 text-sm/6">
                                    <label for="person-{{ $optionValue->id }}" class="select-none font-medium text-gray-900">{{ $optionValue->name }}</label>
                                </div>
                                <div class="flex shrink-0 items-center">
                                    <div class="group grid size-4 grid-cols-1">
                                        <input
                                            id="person-{{ $optionValue->id }}"
                                            name="person-{{ $optionValue->id }}"
                                            type="checkbox"
                                            value="{{ $optionValue->id }}"
                                            wire:model="selectedOptionsValues"
                                            wire:change="optionvalueChanged({{ $optionValue->id }})"
                                            class="col-start-1 row-start-1 appearance-none rounded bg-white checked:border-indigo-600 checked:bg-indigo-600 indeterminate:border-indigo-600 indeterminate:bg-indigo-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-indigo-600 disabled:border-gray-300 disabled:bg-gray-100 disabled:checked:bg-gray-100 forced-colors:appearance-auto">
                                        <svg class="pointer-events-none col-start-1 row-start-1 size-3.5 self-center justify-self-center stroke-white group-has-[:disabled]:stroke-gray-950/25" viewBox="0 0 14 14" fill="none">
                                            <path class="opacity-0 group-has-[:checked]:opacity-100" d="M3 8L6 11L11 3.5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                            <path class="opacity-0 group-has-[:indeterminate]:opacity-100" d="M3 7H11" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
{{--                    <label for="newOptionValue">{{ __('New value') }}</label>--}}
                    <div class="mt-2 grid grid-cols-1">
                        <input type="text" placeholder="{{ __('daylight::store.new_value') }}" wire:model="newOptionValue" id="newOptionValue" class="block w-full rounded-md bg-white px-3 py-1.5 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                        <button wire:click.prevent="addNewOptionValue" class="mt-2 py-2.5 px-4 border rounded-md text-sm leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out bg-white text-sky-600 hover:opacity-75 border-sky-600">
                            {{ __('daylight::general.add') }}
                        </button>
                    </div>
                @endif
            </div>

            <div>
                @if($selectedOptionsValues)
                    <label for="apply">{{ __('daylight::store.apply_options') }}</label>
                    <div class="grid grid-cols-1">
                        <button wire:click.prevent="applyOptions" class="mt-2 py-2.5 px-4 border rounded-md text-sm leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out bg-sky-600 text-white hover:bg-sky-700 border-sky-600 text-sm">
                            {{ __('daylight::store.apply_to_product') }}
                        </button>
                    </div>
                @endif
            </div>

        </div>
    </div>
</div>
