<?php

namespace Daylight\Core\Http\Controllers\Store;

use App\Models\User;
use Daylight\Core\Http\Controllers\Controller;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class UserController extends Controller implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:create:users', only: ['create', 'store']),
            new Middleware('can:read:users', only: ['index', 'show']),
            new Middleware('can:update:users', only: ['edit', 'update']),
            new Middleware('can:delete:users', only: ['destroy']),
        ];
    }

    public function index(): View
    {
        return view('daylight::store.users.index');
    }

    public function show(User $user)
    {
        $user = User::query()
            ->withCount('orders')
            ->with([
                'customer',
            ])
            ->findOrFail($user->id);

        return view('daylight::store.users.show', [
            'user' => $user,
        ]);
    }

    public function leaveImpersonation()
    {
        $currentUser = Auth::user();

        Auth::user()->leaveImpersonation();

        return redirect()->route('daylight.store.users.show', $currentUser);
    }
}
