<?php

namespace Daylight\Core\Models\Concerns;

use App\Notifications\InviteUserNotification;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

trait InteractsWithDaylightUser
{
    public function fullName(): Attribute
    {
        return Attribute::make(
            get: fn () => $this->name . ' ' . $this->last_name
        );
    }

    public function avatar(): Attribute
    {
        return Attribute::make(
            get: fn () => sprintf('https://gravatar.com/avatar/%s?s=192', hash('sha256', strtolower($this->email)))
        );
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(daylightModel('customer'));
    }

    public function orders(): HasMany
    {
        return $this->hasMany(daylightModel('order'));
    }

    //    public function sendInviteNotification(): void
    //    {
    //        $this->notify(new InviteUserNotification($this));
    //    }

}
