<?php

namespace Daylight\Core\Models\Translations;

use Daylight\Core\Modules\MediaLibrary\Contracts\HasMedia;
use Daylight\Core\Modules\MediaLibrary\Models\Concerns\InteractsWithMedia;
use Daylight\Core\Modules\PageBuilder\Concerns\InteractsWithComponents;
use Daylight\Core\Modules\PageBuilder\Contracts\HasComponents;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BrandTranslation extends Model implements HasComponents, HasMedia
{
    use InteractsWithComponents;
    use InteractsWithMedia;

    protected $guarded = [];

    public function brand(): BelongsTo
    {
        return $this->belongsTo(daylightModel('brand'));
    }
}
