<?php

namespace Daylight\Core\Modules\Payment\Entities;

use Daylight\Core\Modules\Payment\Enums\PaymentStatus as PaymentStatusEnum;

class PaymentStatus
{
    public function __construct(
        public string $transactionId,
        public string $status,
        public PaymentStatusEnum $formattedStatus,
    ) {
        //
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function getFormattedStatus(): PaymentStatusEnum
    {
        return $this->formattedStatus;
    }
}
