@extends('daylight::layouts.app')

@section('title', __('daylight::settings.settings'))

@section('content')
    <x-daylight::page-header :title="__('daylight::settings.general')" />

    <x-daylight::session-messages />

    <form method="post" action="{{ route('daylight.settings.general.update') }}">
        @csrf
        @method('PUT')

        <x-daylight::input.group
                :label="__('daylight::general.front_page')"
                :error="$errors->first('frontPage')"
                for="frontPage"
        >
            <x-daylight::input.select name="frontPage" id="frontPage" :disabled="!auth()->user()->can('update:settings')">
                @foreach($pages as $page)
                    <option value="{{ $page->id }}" @if($page->id == old('frontPage', $settings->frontPage)) selected @endif>
                        {{ $page->translations->first()->name }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <h3 class="font-medium text-lg text-gray-900 mt-6 mb-2">{{ __('daylight::general.company') }}</h3>

        @php
            $fields = [
                'name' => __('daylight::general.name'),
                'addressLine1' => __('daylight::general.address_line_1'),
                'addressLine2' => __('daylight::general.address_line_2'),
                'postalCode' => __('daylight::general.postal_code'),
                'city' => __('daylight::general.city'),
                'country' => __('daylight::general.country'),
                'email' => __('daylight::general.email'),
                'phoneNumber' => __('daylight::general.phone_number')
            ];
        @endphp

        @foreach($fields as $key => $field)
            <x-daylight::input.group
                :label="$field"
                :error="$errors->first($key)"
                for="{{ $key }}"
            >
                @if($key === 'country')
                    <x-daylight::input.select name="country" id="country" :disabled="!auth()->user()->can('update:settings')">
                        @foreach($countries as $key => $country)
                            <option value="{{ $key }}" @if($key == old('country', $settings->country)) selected @endif>
                                {{ $country }}
                            </option>
                        @endforeach
                    </x-daylight::input.select>
                @else
                    <x-daylight::input.text :name="$key" :id="$key" value="{{ old($key, $settings->$key) }}" :disabled="!auth()->user()->can('update:settings')"/>
                @endif
            </x-daylight::input.group>
        @endforeach

        <hr>

        <h3 class="font-medium text-lg text-gray-900 mt-6 mb-2">{{ __('daylight::general.social_media') }}</h3>

        @php
            $fields = [
                'facebookUrl' => __('daylight::general.facebook_url'),
                'instagramUrl' => __('daylight::general.instagram_url'),
                'youtubeUrl' => __('daylight::general.youtube_url'),
                'linkedinUrl' => __('daylight::general.linkedin_url'),
            ];
        @endphp

        @foreach($fields as $key => $field)
            <x-daylight::input.group
                :label="$field"
                :error="$errors->first($key)"
                for="{{ $key }}"
            >
                <x-daylight::input.text :name="$key" :id="$key" value="{{ old($key, $settings->$key) }}" :disabled="!auth()->user()->can('update:settings')"/>
            </x-daylight::input.group>
        @endforeach

        @can('update:settings')
            <div class="mt-6 flex items-center justify-end gap-x-3">
                <x-daylight::buttons.primary type="submit">
                    {{ __('daylight::general.save') }}
                </x-daylight::buttons.primary>
            </div>
        @endcan
    </form>
@endsection
