@extends('daylight::layouts.app')

@section('title', __('daylight::store.edit_brand'))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('daylight::general.edit_page', ['page' => $brand->name])">
            @can('update:brands')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('daylight::store.delete_brand') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.store.brands.update', $brand) }}">
            @csrf
            @method('PUT')
            <input type="hidden" name="locale" value="{{ request()->get('locale', app()->getLocale()) }}">

            <x-daylight::input.group
                :label="__('daylight::general.name')"
                :error="$errors->first('name')"
                for="code"
            >
                <x-daylight::input.text
                    name="name"
                    id="name"
                    value="{{ old('name', $brand->name) }}"
                    :disabled="!auth()->user()->can('update:brands')"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('daylight::general.color')"
                :error="$errors->first('color')"
                for="code"
            >
                <x-daylight::input.color
                    name="color"
                    id="color"
                    value="{{ old('color', $brand->color) }}"
                    :disabled="!auth()->user()->can('update:brands')"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('daylight::general.logo')"
                :error="$errors->first('logo')"
                for="logo"
            >
                <div wire:ignore>
                    <div data-vue-app>
                        <media-selector
                            name="logo"
                            :single-file="false"
                            :initial-media='@json(old('media', $brand->gallery))'
                        />
                    </div>
                </div>
            </x-daylight::input.group>

            <x-daylight::locale-selector :route="route('daylight.store.brands.edit', $brand)"/>

            <x-daylight::input.group
                :label="__('daylight::general.components')"
                :error="$errors->first('components')"
                for="components"
            >
                <div wire:ignore>
                    <div data-vue-app>
                        <page-builder
                            :components='@json(old('components', $components) ? json_decode(old('components', $components)) : [])'
                            :available-components='@json($availableComponents)'
                        />
                    </div>
                </div>
            </x-daylight::input.group>

            <x-daylight::seo :page="$translation"/>

            @can('update:brands')
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.store.brands.index') }}" element="a">
                        {{ __('daylight::general.cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('daylight::general.save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endcan
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900"
                    id="modal-title">{{ __('daylight::general.delete_object', ['object' => __('daylight::store.daylight::store.brand')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('daylight::general.delete_confirm', ['object' => __('daylight::store.daylight::store.brand')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.store.brands.destroy', $brand) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto"
                            @click.prevent="showConfirmDeleteModal = false">
                        {{ __('daylight::general.cancel') }}
                    </button>

                    <button type="submit"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('daylight::general.delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
