<?php

namespace Daylight\Core\Http\Requests\Store\Brands;

use Daylight\Core\Http\Requests\Concerns\HandlesSeoRequest;
use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Daylight\Core\Modules\PageBuilder\Concerns\InteractsWithPageBuilder;
use Daylight\Core\Modules\PageBuilder\Contracts\HasPageBuilder;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateBrandRequest extends FormRequest implements HasPageBuilder
{
    use HandlesSeoRequest;
    use InteractsWithPageBuilder;

    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:brands');
    }

    public function rules(): array
    {
        return [
            'locale' => ['required', 'string', Rule::in(Multilingualism::getAvailableLocales())],
            'name' => ['required', 'string', 'max:255'],
            'color' => ['nullable', 'string', 'max:255'],
            'logo' => ['nullable'],
            'logo.*.id' => ['exists:media,id'],
            ...$this->getSeoRules(),
            ...$this->getPageBuilderRules(
                required: false,
            ),
        ];
    }

    public function prepareForValidation(): void
    {
        $this->merge([
            'logo' => json_decode($this->input('logo'), true),
            'components' => json_decode($this->input('components'), true),
        ]);
    }
}
