<?php

namespace Daylight\Core\Http\Requests\Store\Categories;

use Daylight\Core\Http\Requests\Concerns\HandlesSeoRequest;
use Daylight\Core\Modules\PageBuilder\Concerns\InteractsWithPageBuilder;
use Daylight\Core\Modules\PageBuilder\Contracts\HasPageBuilder;
use Illuminate\Foundation\Http\FormRequest;

class UpdateCategoryRequest extends FormRequest implements HasPageBuilder
{
    use HandlesSeoRequest;
    use InteractsWithPageBuilder;

    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:categories');
    }

    public function rules(): array
    {
        return [
            'parent_id' => ['nullable', 'exists:categories,id'],
            'name' => ['required', 'string', 'max:255'],
            'locale' => ['required', 'string', 'max:255'],
            ...$this->getSeoRules(),
            ...$this->getPageBuilderRules(
                required: false
            ),
        ];
    }
}
