<?php

namespace Daylight\Core\Modules\PageBuilder;

use Daylight\Core\Modules\PageBuilder\Registries\ComponentRegistry;
use Daylight\Core\Modules\PageBuilder\Registries\TemplateRegistry;
use Illuminate\Support\ServiceProvider;

class PageBuilderServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->app->singleton(ComponentRegistry::class, function () {
            return new ComponentRegistry;
        });

        $this->app->singleton(TemplateRegistry::class, function () {
            return new TemplateRegistry;
        });
    }
}
