<template x-teleport="body">
    <div 
        x-show="showOptionSlideOver"
        class="relative z-30"
        style="display: none;"
    >
        <!-- Backdrop -->
        <div
            x-show="showOptionSlideOver"
            x-transition:enter="transition-opacity ease-linear duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition-opacity ease-linear duration-300"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            @click="close"
            class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity z-40"
        ></div>

        <!-- Panel -->
        <div class="fixed inset-0 overflow-hidden z-50" @click.self="close">
            <div class="absolute inset-0 overflow-hidden" @click.self="close">
                <div class="pointer-events-none fixed inset-y-0 right-0 flex max-w-full pl-10" @click.self="close">
                    <div
                        x-show="showOptionSlideOver"
                        x-transition:enter="transform transition ease-in-out duration-500 sm:duration-700"
                        x-transition:enter-start="translate-x-full"
                        x-transition:enter-end="translate-x-0"
                        x-transition:leave="transform transition ease-in-out duration-500 sm:duration-700"
                        x-transition:leave-start="translate-x-0"
                        x-transition:leave-end="translate-x-full"
                        class="pointer-events-auto w-screen max-w-2xl"
                    >
                <form
                    x-data='{
                        option: {
                            id: null,
                            translations: @json(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales()->mapWithKeys(function($locale) { return [$locale => ['name' => '']]; })),
                            type: "buttons",
                            optionValues: []
                        }
                    }'
                    x-modelable="option"
                    x-model="currentOption"
                    @submit.prevent="
                        $dispatch('sync-option-values');
                        $nextTick(() => {
                            if (isCreatingNewOption) {
                                options.push({...option});
                                // Clear server data when adding new option to regenerate variants
                                serverVariants = [];
                                selectedVariants = [];
                            } else {
                                options = options.map(o => o.id === option.id ? option : o);
                            }
                            close();
                        });
                    "
                    class="h-full"
                >
                    <div class="flex h-full flex-col overflow-y-scroll bg-white shadow-xl">
                        <div class="flex-1">
                            <div class="bg-sky-600 px-4 py-6 sm:px-6">
                                <div class="flex items-start justify-between space-x-3">
                                    <div class="space-y-1">
                                        <h2 class="text-base font-semibold leading-6 text-white"
                                            id="slide-over-title">{{ __('daylight::store.product_option') }}</h2>
                                        <p class="text-sm text-white text-opacity-75">{{ __('daylight::store.add_options_message') }}</p>
                                    </div>

                                    <div class="flex h-7 items-center">
                                        <button @click.prevent="close" type="button"
                                                class="relative text-gray-400 hover:text-gray-500">
                                            <span class="absolute -inset-2.5"></span>
                                            <span class="sr-only">{{ __('daylight::general.close_panel') }}</span>
                                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                                 stroke="currentColor" aria-hidden="true">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                      d="M6 18L18 6M6 6l12 12"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="space-y-6 py-6 sm:space-y-0 sm:divide-y sm:divide-gray-200 sm:py-0">
                                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                                    <div
                                        class="space-y-2 px-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:space-y-0 sm:px-6 sm:py-5">
                                        <div>
                                            <label for="name"
                                                   class="text-sm font-medium leading-6 text-gray-900 sm:mt-1.5 flex items-center">
                                                {{ __('daylight::general.name_locale', ['locale' => 'NL' ]) }}
                                            </label>
                                        </div>
                                        <div class="sm:col-span-2">
                                            <input x-model="option.translations['{{ $locale }}'].name" type="text"
                                                   id="name"
                                                   class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-indigo-600 sm:text-sm sm:leading-6">
                                        </div>
                                    </div>
                                @endforeach

                                <div
                                    class="space-y-2 px-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:space-y-0 sm:px-6 sm:py-5">
                                    <div>
                                        <label for="optionType"
                                               class="text-sm font-medium leading-6 text-gray-900 sm:mt-1.5 flex items-center">
                                            {{ __('daylight::general.type') }}
                                        </label>
                                    </div>
                                    <div class="sm:col-span-2">
                                        <select x-model="option.type" name="optionType" id="optionType" class="appearance-none w-full pl-3 pr-10 block h-10 py-2 text-base sm:text-sm leading-none rounded-lg shadow-xs border bg-white dark:bg-white/10 dark:disabled:bg-white/[9%] text-zinc-700 dark:text-zinc-300 has-[option.placeholder:checked]:text-zinc-400 dark:has-[option.placeholder:checked]:text-zinc-400 dark:[&>option]:bg-zinc-700 dark:[&>option]:text-white disabled:shadow-none border border-zinc-200 border-b-zinc-300/80 dark:border-white/10">
                                            <option value="buttons">{{ __('daylight::store.buttons') }}</option>
                                            <option value="swatches">{{ __('daylight::store.swatches') }}</option>
                                            <option value="select">{{ __('daylight::general.select') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <x-daylight::variation-builder.option-values/>
                        </div>

                        <!-- Action buttons -->
                        <div class="flex-shrink-0 border-t border-gray-200 px-4 py-5 sm:px-6">
                            <div class="flex justify-end space-x-3">
                                <button type="button" @click.prevent="close"
                                        class="bg-white text-sky-600 hover:opacity-75 border-sky-600 py-2.5 px-4 border rounded-md text-sm leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out">
                                    {{ __('daylight::general.cancel') }}
                                </button>

                                <button type="submit"
                                        class="bg-sky-600 text-white hover:bg-sky-700 border-sky-600 text-sm py-2.5 px-4 border rounded-md leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out">
                                    {{ __('daylight::general.save') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
                </div>
            </div>
        </div>
    </div>
</template>
