@extends('daylight::layouts.app')

@section('title', __('daylight::store.edit_label'))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('daylight::store.edit_label')">
            @can('delete:labels')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('daylight::store.delete_label') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.store.labels.update', $label) }}">
            @csrf
            @method('PUT')

            <x-daylight::input.group
                :label="__('daylight::store.background')"
                :error="$errors->first('background')"
                for="background"
            >
                <x-daylight::input.color
                    name="background"
                    id="background"
                    value="{{ old('background', $label->background) }}"
                    placeholder="#000000"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('daylight::store.text_color')"
                :error="$errors->first('text_color')"
                for="text_color"
            >
                <x-daylight::input.color
                    name="text_color"
                    id="text_color"
                    value="{{ old('text_color', $label->text_color) }}"
                    placeholder="#FFFFFF"
                />
            </x-daylight::input.group>

            <div class="mt-6">
                <h2 class="text-lg leading-loose font-medium">{{ __('daylight::general.translations') }}</h2>
            </div>

            @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                <x-daylight::input.group
                        :label="__('daylight::store.name_locale', ['locale' => strtoupper($locale)])"
                        :error="$errors->first('translations.' . $locale . '.name')"
                        for="translations[{{ $locale }}][name]"
                >
                    <x-daylight::input.text
                            name="translations[{{ $locale }}][name]"
                            id="translations[{{ $locale }}][name]"
                            value="{{ old('translations.' . $locale . '.name', $label->translations->firstWhere('locale', $locale)->name) }}"
                            :disabled="!auth()->user()->can('update:labels')"
                    />
                </x-daylight::input.group>
            @endforeach

            @can('update:labels')
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.store.labels.index') }}" element="a">
                        {{ __('daylight::general.cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('daylight::general.save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endcan
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900"
                    id="modal-title">{{ __('daylight::general.delete_object', ['object' => __('daylight::store.label')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('daylight::general.delete_confirm', ['object' => __('daylight::store.label')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.store.labels.destroy', $label) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto"
                            @click.prevent="showConfirmDeleteModal = false">
                        {{ __('daylight::general.cancel') }}
                    </button>

                    <button type="submit"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('daylight::general.delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
