<?php

namespace Daylight\Core\Livewire\Store;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Models\Product;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class ProductVariantTable extends BaseTable
{
    //    use WithSearch;

    public Product $product;

    protected function getBaseQuery(): Builder
    {
        return $this->product->variants()->with([
            'taxClass',
            'media',
            'optionValues.option.translations',
            'optionValues.translations',
        ])->latest()->getQuery();
    }

    public function getSearchQueryArgument(): string
    {
        return 'variantSearchQuery';
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->where('sku', 'like', "%{$searchQuery}%")
                ->orWhere('name', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.product-variant-table');
    }
}
