<?php

namespace Daylight\Core\Models\Enums;

use Illuminate\Support\Collection;

enum ProductStatus: int
{
    case INACTIVE = 0;

    case DRAFT = 1;

    case PUBLISHED = 2;

    public function label(): string
    {
        return match ($this) {
            self::INACTIVE => __('Inactive'),
            self::DRAFT => __('Draft'),
            self::PUBLISHED => __('Published'),
        };
    }

    public function adminColor(): string
    {
        return match ($this) {
            self::PUBLISHED => 'bg-green-50 text-green-700',
            self::DRAFT => 'bg-yellow-50 text-yellow-700',
            self::INACTIVE => 'bg-red-50 text-red-700',
        };
    }

    public static function formattedValues(): Collection
    {
        return collect(self::cases())
            ->mapWithKeys(function (ProductStatus $status) {
                return [$status->value => $status->label()];
            });
    }
}
