<?php

namespace Daylight\Core\Models\Shipping;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ShippingZone extends Model
{
    protected $guarded = [];

    public function shippingClasses()
    {
        return $this->belongsToMany(daylightModel('shipping_class'), daylightModel('shipping_zone_rule'));
    }

    public function shippingZoneRules(): HasMany
    {
        return $this->hasMany(daylightModel('shipping_zone_rule'));
    }

    public function countries(): BelongsToMany
    {
        return $this->belongsToMany(daylightModel('country'));
    }
}
