@extends('daylight::layouts.app')

@section('title', __('daylight::settings.create_role'))

@section('content')
    <x-daylight::page-header :title="__('daylight::settings.create_role')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.settings.roles.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('daylight::general.name')"
            :error="$errors->first('name')"
            for="code"
        >
            <x-daylight::input.text
                name="name"
                id="name"
                value="{{ old('name') }}"
            />
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('daylight::general.permissions')"
            :error="$errors->first('permissions')"
            for="permissions"
        >
            <div class="grid grid-cols-3 gap-x-4 gap-y-1">
                @foreach($permissions as $permission)
                    <div class="relative flex items-start">
                        <div class="flex h-6 items-center">
                            <input
                                id="{{ $permission->id }}"
                                name="permissions[]"
                                type="checkbox"
                                class="h-4 w-4 rounded border-gray-300 text-sky-600 !ring-0 !outline-0"
                                value="{{ $permission->id }}"
                                {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}
                            >
                        </div>
                        <div class="ml-3 text-sm leading-6">
                            <label for="{{ $permission->id }}" class="text-gray-900"> {{ $permission->name }}</label>
                        </div>
                    </div>
                @endforeach
            </div>
        </x-daylight::input.group>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.settings.roles.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
