@extends('daylight::layouts.app')

@section('title', $product->translations->first()->name)

@section('content')
    <x-daylight::page-header :title="$product->translations->first()->name">
        @can('read:products')
            <x-daylight::buttons.secondary class="mr-2" element="a" href="{{ route(request()->get('locale', app()->getLocale()) . '_products.show', ['any' => $product->slug]) }}" target="_blank">
                {{ __('daylight::store.view_product') }}
            </x-daylight::buttons.secondary>
        @endif

        @can('update:products')
            <x-daylight::buttons.primary element="a" href="{{ route('daylight.store.products.edit', ['product' => $product->id, 'locale' => request()->get('locale', app()->getLocale())]) }}">
                {{ __('daylight::store.edit_product') }}
            </x-daylight::buttons.primary>
        @endif
    </x-daylight::page-header>

    <x-daylight::session-messages/>

    <div class="lg:grid lg:grid-cols-12 gap-8">
        <div class="col-span-8">
            <x-daylight::locale-selector :route="route('daylight.store.products.show', $product)"/>

            <x-daylight::input.group :label="__('daylight::general.name')">
                <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
                    {{ $product->translations->first()->name }}
                </p>
            </x-daylight::input.group>

            <x-daylight::input.group :label="__('daylight::general.status')">
                <div class="inline-flex rounded px-2 py-1 border text-xs {{ $product->status->adminColor() }}">
                    {{ $product->status->label() }}
                </div>
            </x-daylight::input.group>

            <x-daylight::input.group :label="__('daylight::general.name')">
                <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
                    @if($product->brand)
                        <a href="{{ route('daylight.store.brands.edit', $product->brand) }}" class="text-sky-700">
                            {{ $product->brand?->name }}
                        </a>
                    @else
                        {{ $product->brand?->name }}
                    @endif
                </p>
            </x-daylight::input.group>

            @if($product->labels->isNotEmpty())
                <x-daylight::input.group :label="__('daylight::store.labels')">
                    <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
                        {{ $product->labels->map(fn($c) => $c->translations->first()->name)->join(', ') }}
                    </p>
                </x-daylight::input.group>
            @endif

            @if($product->categories->isNotEmpty())
                <x-daylight::input.group :label="__('daylight::general.category')">
                    <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
                        {{ $product->categories->map(fn($c) => $c->translations->first()->name)->join(', ') }}
                    </p>
                </x-daylight::input.group>
            @endif

            @foreach($product->attributeValues->groupBy('attribute_id') as $attributeValues)
                <x-daylight::input.group :label="$attributeValues->first()->attribute->translations->first()->name">
                    <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
                        @foreach($attributeValues as $attributeValue)
                            @if($attributeValue->translations->first())
                                <a href="{{ route('daylight.store.attributes.edit', $attributeValue->attribute) }}"
                                   class="text-sky-700">
                                    {{ $attributeValue->translations->first()->name }}
                                </a>
                            @else
                                {{ $attributeValue->translations->first()->name }}
                            @endif
                            @if(!$loop->last)
                                /
                            @endif
                        @endforeach
                    </p>
                </x-daylight::input.group>
            @endforeach

            @if($product->translations->first()->description)
                <x-daylight::input.group :label="__('Description')">
                    <div class="block text-sm leading-6 text-gray-700 sm:pt-1.5 prose max-w-none">
                        {!! $product->translations->first()->description !!}
                    </div>
                </x-daylight::input.group>
            @endif

            @if($product->downloads->isNotEmpty())
                <x-daylight::input.group :label="__('Downloads')">
                    <div class="space-y-2">
                        @foreach($product->downloads as $download)
                            <div class="border w-full p-3 text-gray-600 rounded-lg text-sm flex items-center">
                                <svg class="w-4 h-4 mr-2 text-gray-600" data-slot="icon" fill="none" stroke-width="1.5"
                                     stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"
                                     aria-hidden="true">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                          d="m18.375 12.739-7.693 7.693a4.5 4.5 0 0 1-6.364-6.364l10.94-10.94A3 3 0 1 1 19.5 7.372L8.552 18.32m.009-.01-.01.01m5.699-9.941-7.81 7.81a1.5 1.5 0 0 0 2.112 2.13"></path>
                                </svg>
                                {{ $download->name }}
                            </div>
                        @endforeach
                    </div>
                </x-daylight::input.group>
            @endif

            <div class="mt-6 mb-4">
                <h2 class="text-lg leading-loose font-medium">{{ __('daylight::store.variants') }}</h2>
            </div>

            <livewire:daylight::product-variant-table :product="$product"/>
        </div>

        <div class="hidden lg:block col-span-4">
            @if($product->gallery->first())
                <img src="{{ $product->gallery->first()->getUrl('large') }}" alt="{{ $product->name }}"
                     class="w-full max-w-sm border rounded-lg">
            @endif

            <ul class="grid grid-cols-4 gap-4 max-w-sm mt-4">
                @foreach($product->gallery->skip(1) as $media)
                    @if($media->type === 'video/mp4')
                        <li>
                            <div
                                class="w-full aspect-square rounded-lg border relative flex items-center justify-center">
                                <div
                                    class="absolute bg-black bg-opacity-50 inset-0 flex items-center justify-center backdrop-blur rounded-lg">
                                    <svg class="w-6 h-6 text-white" data-slot="icon" fill="none" stroke-width="1.5"
                                         stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"
                                         aria-hidden="true">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                              d="m15.75 10.5 4.72-4.72a.75.75 0 0 1 1.28.53v11.38a.75.75 0 0 1-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25h-9A2.25 2.25 0 0 0 2.25 7.5v9a2.25 2.25 0 0 0 2.25 2.25Z"></path>
                                    </svg>
                                </div>

                                @if($product->gallery->first())
                                    <img src="{{ $product->getFirstMedia('gallery')->getUrl('thumbnail') }}"
                                         alt="{{ $product->name }}" class="w-full max-w-sm border rounded-lg">
                                @endif
                            </div>
                        </li>
                    @else
                        <li>
                            <img src="{{ $media->getUrl('thumbnail') }}" alt="{{ $product->name }}"
                                 class="w-full border rounded-lg">
                        </li>
                    @endif
                @endforeach
            </ul>
        </div>
    </div>

@endsection
