<?php

namespace Daylight\Core\Modules\Admin\Providers;

use Daylight\Core\Modules\Admin\Registries\ShortcutRegistry;
use Daylight\Core\Modules\Admin\View\Composers\ShortcutViewComposer;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ShortcutServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(ShortcutRegistry::class, function () {
            return new ShortcutRegistry;
        });

        View::composer('daylight::dashboard', ShortcutViewComposer::class);
    }
}
