<?php

namespace Daylight\Core\Modules\Admin\Registries;

use Daylight\Core\Modules\Admin\Entities\Contracts\Asset;
use Daylight\Core\Modules\Admin\Entities\Script;
use Daylight\Core\Modules\Admin\Entities\Stylesheet;
use Illuminate\Support\Collection;

class AssetRegistry
{
    protected Collection $assets;

    public function __construct()
    {
        $this->assets = collect();
    }

    public static function addAsset(Asset $asset): self
    {
        return app(self::class)->register($asset);
    }

    public function register(array|Collection|Asset $assets): self
    {
        if ($assets instanceof Asset) {
            $assets = [$assets];
        }

        if (is_array($assets)) {
            $assets = collect($assets);
        }

        $this->assets = $this->assets->merge($assets);

        return $this;
    }

    public function scripts(): Collection
    {
        return $this->assets->filter(fn (Asset $asset) => $asset instanceof Script);
    }

    public function stylesheets(): Collection
    {
        return $this->assets->filter(fn (Asset $asset) => $asset instanceof Stylesheet);
    }
}
