@props([
    'disabled' => false,
    'readonly' => false,
    'type' => 'textarea',
])

<textarea
    type="{{ $type }}"
    {{ $disabled ? 'disabled' : '' }}
    {{ $readonly ? 'readonly' : '' }}
    {!! $attributes->merge(['class' => 'peer block min-h-[100px] w-full rounded-md border border-gray-300 py-1.5 text-gray-900 shadow-sm placeholder:text-gray-400 sm:max-w-lg sm:text-sm sm:leading-6 ' . ($disabled ? 'bg-gray-100' : '') . ' ' . ( $readonly ? 'bg-gray-100' : '')]) !!}
>{{ $slot }}</textarea>
