@extends('daylight::layouts.app')
@section('title', __('Admin dashboard'))
@section('sidebar', false)

@section('content')
    <h1 class="text-xl leading-loose font-medium">{{ __('Dashboard') }}</h1>

    <div class="lg:grid grid-cols-12 gap-6">
        <dl class="col-span-8 mt-5 grid grid-cols-1 gap-5 sm:grid-cols-2 lg:grid-cols-3">
            @foreach($widgets as $widget)
                {!! $widget->render() !!}
            @endforeach
        </dl>
    </div>

    {{--    @dd($shortcuts)--}}

    <div class="mt-6">
        <h1 class="text-xl leading-loose font-medium">{{ __('Shortcuts') }}</h1>
        <p class="mt-1 text-sm text-gray-500">{{ __('Choose an action below and get started quickly.') }}</p>

        <div class="lg:grid grid-cols-12 gap-6">
            <ul role="list"
                class="col-span-8 mt-6 grid grid-cols-1 gap-6 border-b border-t border-gray-200 py-6 sm:grid-cols-2">
                @foreach($shortcuts as $shortcut)
                    <li class="flow-root">
                        <div class="relative -m-2 flex items-center space-x-4 rounded-xl p-2 focus-within:ring-2 focus-within:ring-indigo-500 hover:bg-gray-100">
                            <div class="flex size-16 shrink-0 items-center justify-center rounded-lg {{ $shortcut->getColor() }}">
                                <x-dynamic-component
                                        :component="'heroicon-' . $shortcut->getIcon()"
                                        class="size-6 text-white"
                                />
                            </div>
                            <div>
                                <h3 class="text-sm font-medium text-gray-900">
                                    <a href="{{ route($shortcut->getRoute()) }}" class="focus:outline-none">
                                        <span class="absolute inset-0" aria-hidden="true"></span>
                                        <span>{{ $shortcut->getLabel()  }}</span>
                                        <span aria-hidden="true"> &rarr;</span>
                                    </a>
                                </h3>
                                <p class="mt-1 text-sm text-gray-500">
                                    {{ $shortcut->getDescription() }}
                                </p>
                            </div>
                        </div>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@endsection
