<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Created at') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column class="flex items-center">
                <a href="{{ route('daylight.settings.roles.edit', $row) }}" class="flex items-center">
                    {{ $row->name }}

                    @if($row->locked)
                        <svg class="ml-2 w-4 h-4" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 0 0 2.25-2.25v-6.75a2.25 2.25 0 0 0-2.25-2.25H6.75a2.25 2.25 0 0 0-2.25 2.25v6.75a2.25 2.25 0 0 0 2.25 2.25Z"></path>
                        </svg>
                    @endif
                </a>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->created_at->isoFormat('LLL') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.settings.roles.edit', $row) }}"
                   class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    Edit
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
