<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Status') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Created at') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column class="flex items-center">
                <a href="{{ route('daylight.store.products.show', $row) }}" class="flex items-center">
                    @if($row->getFirstMedia())
                        <img src="{{ $row->getFirstMedia()->getUrl('square-small') }}" alt="{{ $row->name }}" class="h-12 w-12 object-cover rounded-md">
                    @endif

                    <h3 class="ml-4">{{ $row->name }}</h3>
                </a>
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                <span class="rounded px-2 py-1 border text-xs {{ $row->status->adminColor() }}">
                    {{ $row->status->label() }}
                </span>
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                {{ $row->created_at->format('d-m-Y H:i') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.store.products.show', $row) }}"
                   class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" class="w-5 h-5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 0 1 0-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178Z" />
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                    </svg>
                </a>

                @can('update:products')
                    <a href="{{ route('daylight.store.products.edit', $row) }}"
                       class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" class="w-5 h-5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                        </svg>
                    </a>
                @endcan
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
