@extends('daylight::layouts.app')

@section('title', __('Edit role'))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('Edit :page', ['page' => $role->name])">
            @if(auth()->user()->can('update:advanced-settings') && !$role->locked)
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete role') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.settings.roles.update', $role) }}">
            @csrf
            @method('PUT')

            <x-daylight::input.group
                :label="__('Name')"
                :error="$errors->first('name')"
                for="code"
            >
                <x-daylight::input.text
                    name="name"
                    id="name"
                    value="{{ old('name', $role->name) }}"
                    :disabled="!auth()->user()->can('update:advanced-settings') || $role->locked"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Permissions')"
                :error="$errors->first('permissions')"
                for="permissions"
            >
                <div class="grid grid-cols-3 gap-x-4 gap-y-1">
                    @foreach($permissions as $permission)
                        <div class="relative flex items-start">
                            <div class="flex h-6 items-center">
                                <input
                                    disabled="{{ !auth()->user()->can('update:advanced-settings') || $role->locked }}"
                                    id="{{ $permission->id }}"
                                    name="permissions[]"
                                    type="checkbox"
                                    class="h-4 w-4 rounded border-gray-300 text-sky-600 !ring-0 !outline-0"
                                    value="{{ $permission->id }}"
                                    {{ in_array($permission->id, old('permissions', $role->permissions->pluck('id')->toArray())) ? 'checked' : '' }}
                                >
                            </div>
                            <div class="ml-3 text-sm leading-6">
                                <label for="{{ $permission->id }}" class="text-gray-900"> {{ $permission->name }}</label>
                            </div>
                        </div>
                    @endforeach
                </div>
            </x-daylight::input.group>

            @if(auth()->user()->can('update:advanced-settings') && !$role->locked)
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.settings.roles.index') }}" element="a">
                        {{ __('Cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('Save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endif
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900"
                    id="modal-title">{{ __('Delete :object', ['object' => __('role')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('Are you sure you want to delete this :object? This action cannot be undone.', ['object' => __('role')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.settings.roles.destroy', $role) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto"
                            @click.prevent="showConfirmDeleteModal = false">
                        {{ __('Cancel') }}
                    </button>

                    <button type="submit"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('Delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
