@extends('daylight::layouts.app')

@section('title', __('Edit category'))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('Edit category')">
            @can('update:categories')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete category') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.store.categories.update', $category) }}">
            @csrf
            @method('PUT')

            <input type="hidden" name="locale" value="{{ request()->get('locale', 'en') }}">

            <x-daylight::input.group
                    :label="__('Parent')"
                    :error="$errors->first('parent')"
                    for="parent_id"
            >
                <x-daylight::input.select name="parent_id" id="parent_id"
                                          :disabled="!auth()->user()->can('update:categories')">
                    <option value="">{{ __('No parent') }}</option>

                    @foreach($parents as $parent)
                        @include('daylight::store.categories.partials.parent', ['parent' => $parent, 'level' => 0])
                    @endforeach
                </x-daylight::input.select>
            </x-daylight::input.group>

            <x-daylight::locale-selector :route="route('daylight.store.categories.edit', $category)"/>

            <div x-data="{ name: '{{ old('name', $translation?->name) }}', slug: '{{ old('slug', $translation?->slug) }}'}">
                <x-daylight::input.group
                        :label="__('Name')"
                        :error="$errors->first('name')"
                        for="code"
                >
                    <x-daylight::input.text
                            name="name"
                            id="name"
                            value="{{ old('name', $translation?->name) }}"
                            :disabled="!auth()->user()->can('update:categories')"
                            x-model="name"
                    />
                </x-daylight::input.group>

                <x-daylight::input.group
                        :label="__('Slug')"
                        :error="$errors->first('slug')"
                        for="slug"
                >
                    <x-daylight::input.text
                            name="slug"
                            id="slug"
                            value="{{ old('slug', $translation?->slug) }}"
                            :disabled="!auth()->user()->can('update:categories')"
                            x-slug="name"
                    />
                </x-daylight::input.group>
            </div>

            <x-daylight::seo :page="$translation"/>

            <div>
                <h2 class="mt-12">{{ __('Components') }}</h2>

                <x-daylight::input.group
                        :label="__('Components')"
                        :error="$errors->first('components')"
                        for="components"
                >
                    <div wire:ignore>
                        <div data-vue-app>
                            <page-builder
                                    :components='@json(old('components', $components ?? collect()))'
                                    :available-components='@json($availableComponents)'
                            />
                        </div>
                    </div>
                </x-daylight::input.group>
            </div>

            @can('update:categories')
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.store.categories.index') }}" element="a">
                        {{ __('Cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('Save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endcan
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900"
                    id="modal-title">{{ __('Delete :object', ['object' => __('category')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('Are you sure you want to delete this :object? This action cannot be undone.', ['object' => __('category')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.store.categories.destroy', $category) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto"
                            @click.prevent="showConfirmDeleteModal = false">
                        {{ __('Cancel') }}
                    </button>

                    <button type="submit"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('Delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
