<?php

namespace Daylight\Core\Livewire\Store\Products;

use Daylight\Core\Modules\MediaLibrary\Contracts\HasMedia;
use Ijpatricio\Mingle\Concerns\InteractsWithMingles;
use Ijpatricio\Mingle\Contracts\HasMingles;
use Livewire\Component;

class MediaSelector extends Component implements HasMingles
{
    use InteractsWithMingles;

    public string $name;

    public ?HasMedia $product = null;

    public ?array $media = [];

    public string $displayType = 'gallery';

    public function component(): string
    {
        return 'resources/js/admin/MediaSelector/MediaSelector.js';
    }

    public function mingleData(): array
    {
        return [
            'name' => $this->name,
            'initialMedia' => $this->product
                ? $this->product->media->sortBy('pivot.order')->values()->toArray()
                : [],
            'displayType' => $this->displayType,
        ];
    }
}
