<?php

namespace Daylight\Core\Models;

use Daylight\Core\Models\Translations\OptionValueTranslation;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class OptionValue extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['name'];
    }

    public function option(): BelongsTo
    {
        return $this->belongsTo(Option::class);
    }

    public function variants(): BelongsToMany
    {
        return $this->belongsToMany(Variant::class)->withTimestamps();
    }

    public function translations(): HasMany
    {
        return $this->hasMany(OptionValueTranslation::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(OptionValueTranslation::class)
            ->where('locale', config('multilingualism.default_locale'));
    }
}
