<?php

namespace Daylight\Core\Models;

use Daylight\Core\Models\Enums\AssociationType;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductAssociation extends Model
{
    protected $guarded = [];

    protected $casts = [
        'type' => AssociationType::class,
    ];

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function target(): BelongsTo
    {
        return $this->belongsTo(Product::class, 'target_id');
    }

    public function scopeCrossSells($query): Builder
    {
        return $query->type(AssociationType::CROSS_SELL->value);
    }

    public function scopeUpSells($query): Builder
    {
        return $query->type(AssociationType::UP_SELL->value);
    }

    public function scopeType(Builder $query, string $type): Builder
    {
        return $query->whereType($type);
    }
}
