<?php

namespace Daylight\Core\Models\Shipping;

use Daylight\Core\Models\TaxClass;
use Daylight\Core\Models\Variant;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class ShippingClass extends Model
{
    protected $guarded = [];

    protected $casts = [
        'default' => 'bool',
        'cumulative' => 'bool',
        'taxable' => 'bool',
    ];

    public function variants(): BelongsToMany
    {
        return $this->belongsToMany(Variant::class);
    }

    public function shippingZones(): BelongsToMany
    {
        return $this->belongsToMany(ShippingZone::class);
    }

    public function taxClass(): BelongsTo
    {
        return $this->belongsTo(TaxClass::class);
    }
}
