<?php

namespace Daylight\Core\Models\Translations;

use Daylight\Core\Models\Product;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class ProductTranslation extends Model
{
    use HasSlug;

    protected $guarded = [];

    protected $casts = [
        'pros' => 'array',
        'cons' => 'array',
    ];

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug')
            ->extraScope(fn ($builder) => $builder->where('locale', $this->locale));
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
