<?php

namespace Daylight\Core\Modules\Admin\Providers;

use Daylight\Core\Modules\Admin\Registries\NavigationRegistry;
use Daylight\Core\Modules\Admin\View\Composers\NavigationViewComposer;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class NavigationServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(NavigationRegistry::class, function () {
            return new NavigationRegistry;
        });

        View::composer('daylight::layouts.app', NavigationViewComposer::class);
    }
}
