<?php

namespace Daylight\Core\Modules\MenuBuilder\Http\Requests;

use Daylight\Core\Modules\MenuBuilder\Menu;
use Daylight\Core\Modules\MenuBuilder\Registries\MenuRegistry;
use Illuminate\Foundation\Http\FormRequest;

class UpdateNavigationSettingsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:settings');
    }

    public function rules(MenuRegistry $menuRegistry): array
    {
        return $menuRegistry->all()->mapWithKeys(function (Menu $menu) {
            return ['menus.'.$menu->key => ['required', 'integer', 'exists:menus,id']];
        })->toArray();
    }
}
